; FAT filesystem

	module	fat_fs
	
include	"#idedos.def"
include	"#packages.def"
include	"#p3dos.def"
include	"#sysvar48.def"
include "#residos.def"
include	"fatfs.def"
include	"fatfspkg.def"

	; In fat_buffers.asm
	xref	buf_emptybuffers
	
	; In fat_dirs.asm
	xref	dir_catalog
	xref	dir_path

	; In fat_drives.asm
	xref	drive_free_space
	xref	drive_drive
	xref	drive_identify
	xref	drive_partitions
	xref	drive_partitions_physical
	xref	drive_partition_read
	xref	drive_partition_find
	xref	drive_dos_map
	xref	drive_dos_unmap
	xref	drive_dos_mapping
	xref	drive_setupunit
	xref	drive_flush

	; In fat_files.asm
	xref	file_open
	xref	file_close
	xref	file_abandon
	xref	file_ref_head
	xref	file_read
	xref	file_write
	xref	file_byte_read
	xref	file_byte_write
	xref	file_delete
	xref	file_rename
	xref	file_get_position
	xref	file_set_position
	xref	file_get_eof
	xref	file_set_access
	xref	file_set_attributes
	xref	file_snapdata

; ***************************************************************************
; * Package header, call table and restarts                                 *
; ***************************************************************************

	org	0

; TBD: Should use some restarts here, especially for calling back IDEDOS.

	defs	$0038-ASMPC

if (ASMPC<>$0038)
	defs	CODE_ALIGNMENT_ERROR
endif
.im1routine
	push	af
	push	hl
	ld	hl,(FRAMES)
	inc	hl
	ld	(FRAMES),hl		; increment FRAMES
	ld	a,h
	or	l
	jr	nz,im1end
	ld	a,(FRAMES+2)
	inc	a			; inc high byte
	ld	(FRAMES+2),a
.im1end
	pop	hl
	pop	af
	ei
	ret

	defs	$0066-ASMPC

if (ASMPC<>$0066)
	defs	CODE_ALIGNMENT_ERROR
endif
.nmiroutine
	retn
	

; Provide a package call table at a known location, to make
; the external package header easy to build.

	defs	FATFSPKG_CALL_TABLE-ASMPC
	
if (ASMPC<>FATFSPKG_CALL_TABLE)
	defs	CODE_ALIGNMENT_ERROR
endif
.package_call_table
	; Standard calls
	defw	Cfatfspkg_install
	defw	Cfatfspkg_bye
	defw	Cfatfspkg_info
	defw	Cfatfspkg_exp
	defw	Cfatfspkg_hook
	defw	Cfatfspkg_channels
	defw	Cfatfspkg_fs
	defw	Cfatfspkg_nmi
	; Provided calls
if (ASMPC<>(FATFSPKG_CALL_TABLE+(2*(FATFSPKG_MAX_CALL_ID+1))))
	defs	CODE_ALIGNMENT_ERROR
endif



; ***************************************************************************
; * +3DOS/IDEDOS jump tables                                                *
; ***************************************************************************
; Routines which must be implemented are marked "*".
; Routines which may optionally be implemented are marked "?".
; Routines which will never be called are marked "-".

; IDEDOS routines jump block 1.

	defs	ide_version-ASMPC

if (ASMPC<>ide_version)
	defw	CODE_ALIGNMENT_ERROR
endif

.l00a0  jp	fat_notimplemented	; -IDE_VERSION
        jp	fat_notimplemented	; -IDE_INTERFACE
        jp	fat_notimplemented	; -IDE_INIT
	jp	drive_drive		; *IDE_DRIVE
        jp	fat_notimplemented	; -IDE_SECTOR_READ
        jp	fat_notimplemented	; -IDE_SECTOR_WRITE
        jp	fat_notimplemented	; -IDE_FORMAT
	jp	drive_partition_find	; *IDE_PARTITION_FIND
        jp	fat_notimplemented	; ?IDE_PARTITION_NEW
        jp	fat_notimplemented	; ?IDE_PARTITION_INIT
        jp	fat_notimplemented	; ?IDE_PARTITION_ERASE
        jp	fat_notimplemented	; ?IDE_PARTITION_RENAME
	jp	drive_partition_read	; *IDE_PARTITION_READ
        jp	fat_notimplemented	; -IDE_PARTITION_WRITE
        jp	fat_notimplemented	; ?IDE_PARTITION_WINFO
        jp	fat_notimplemented	; -IDE_PARTITION_OPEN
        jp	fat_notimplemented	; -IDE_PARTITION_CLOSE
	jp	fat_notimplemented	; ?IDE_PARTITION_GETINFO
	jp	fat_notimplemented	; ?IDE_PARTITION_SETINFO
        jp	fat_notimplemented	; -IDE_SWAP_OPEN
	jp	fat_notimplemented	; -IDE_SWAP_CLOSE
        jp	fat_notimplemented	; -IDE_SWAP_OUT
        jp	fat_notimplemented	; -IDE_SWAP_IN
        jp	fat_notimplemented	; -IDE_SWAP_EX
        jp	fat_notimplemented	; -IDE_SWAP_POS
        jp	fat_notimplemented	; -IDE_SWAP_MOVE
	jp	fat_notimplemented	; -IDE_SWAP_RESIZE
	jp	drive_dos_map		; *IDE_DOS_MAP
	jp	drive_dos_unmap		; *IDE_DOS_UNMAP
	jp	drive_dos_mapping	; *IDE_DOS_MAPPING
	jp	fat_notimplemented	; -IDE_DOS_UNPERMANENT
	jp	fat_notimplemented	; -IDE_SNAPLOAD

; DOS routines jump block.
if (ASMPC<>DOS_INITIALISE)
		defw	CODE_ALIGNMENT_ERROR
endif

.l0100  jp	fat_notimplemented	; -DOS_INITIALISE
.l0103  jp	fat_notimplemented	; -DOS_VERSION
.l0106	jp	file_open		; *DOS_OPEN
.l0109	jp	file_close		; *DOS_CLOSE
.l010c	jp	file_abandon		; *DOS_ABANDON
.l010f	jp	file_ref_head		; *DOS_REF_HEAD
.l0112	jp	file_read		; *DOS_READ
.l0115	jp	file_write		; *DOS_WRITE
.l0118	jp	file_byte_read		; *DOS_BYTE_READ
.l011b	jp	file_byte_write		; *DOS_BYTE_WRITE
.l011e	jp	dir_catalog		; *DOS_CATALOG
.l0121	jp	drive_free_space	; *DOS_FREE_SPACE
.l0124	jp	file_delete		; *DOS_DELETE
.l0127	jp	file_rename		; *DOS_RENAME
.l012a  jp	fat_notimplemented	; -DOS_BOOT
.l012d  jp	fat_notimplemented	; -DOS_SET_DRIVE
.l0130  jp	fat_notimplemented	; -DOS_SET_USER
.l0133	jp	file_get_position	; *DOS_GET_POSITION
.l0136	jp	file_set_position	; *DOS_SET_POSITION
.l0139	jp	file_get_eof		; *DOS_GET_EOF
.l013c  jp	fat_notimplemented	; -DOS_GET_1346
.l013f  jp	fat_notimplemented	; -DOS_SET_1346
.l0142	jp	drive_flush		; *DOS_FLUSH
.l0145	jp	file_set_access		; *DOS_SET_ACCESS
.l0148	jp	file_set_attributes	; *DOS_SET_ATTRIBUTES
.l014b  jp	fat_notimplemented	; -DOS_OPEN_DRIVE
.l014e  jp	fat_notimplemented	; -DOS_SET_MESSAGE
.l0151  jp	fat_notimplemented	; -DOS_REF_XDPB
.l0154  jp	fat_notimplemented	; -DOS_MAP_B
.l0157  jp	fat_notimplemented	; -DD_INTERFACE
.l015a  jp	fat_notimplemented	; -DD_INIT
.l015d  jp	fat_notimplemented	; -DD_SETUP
.l0160  jp	fat_notimplemented	; -DD_SET_RETRY
.l0163  jp	fat_notimplemented	; -DD_READ_SECTOR
.l0166  jp	fat_notimplemented	; -DD_WRITE_SECTOR
.l0169  jp	fat_notimplemented	; -DD_CHECK_SECTOR
.l016c  jp	fat_notimplemented	; -DD_FORMAT
.l016f  jp	fat_notimplemented	; -DD_READ_ID
.l0172  jp	fat_notimplemented	; -DD_TEST_UNSUITABLE
.l0175  jp	fat_notimplemented	; -DD_LOGIN
.l0178  jp	fat_notimplemented	; -DD_SEL_FORMAT
.l017b  jp	fat_notimplemented	; -DD_ASK_1
.l017e  jp	fat_notimplemented	; -DD_DRIVE_STATUS
.l0181  jp	fat_notimplemented	; -DD_EQUIPMENT
.l0184  jp	fat_notimplemented	; -DD_ENCODE
.l0187  jp	fat_notimplemented	; -DD_L_XDPB
.l018a  jp	fat_notimplemented	; -DD_L_DPB
.l018d  jp	fat_notimplemented	; -DD_L_SEEK
.l0190  jp	fat_notimplemented	; -DD_L_READ
.l0193  jp	fat_notimplemented	; -DD_L_WRITE
.l0196  jp	fat_notimplemented	; -DD_L_ON_MOTOR
.l0199  jp	fat_notimplemented	; -DD_L_T_OFF_MOTOR
.l019c  jp	fat_notimplemented	; -DD_L_OFF_MOTOR

; IDEDOS routines jump block 2.
if (ASMPC<>ide_access_data)
	defw	CODE_ALIGNMENT_ERROR
endif
	jp	fat_notimplemented	; -IDE_ACCESS_DATA
	jp	drive_identify		; ?IDE_IDENTIFY
	jp	drive_partitions	; *IDE_PARTITIONS
	jp	fat_notimplemented	; -IDE_FS_UNIT
	jp	fat_notimplemented	; -IDE_FS_DRIVE
	jp	fat_notimplemented	; -IDE_FS_FILE
	jp	dir_path		; ?IDE_PATH


; ***************************************************************************
; * Standard package calls                                                  *
; ***************************************************************************

if (fatfs_data_end >= PACKAGE_FS_LOWLEVEL)
	defs	DATA_ALIGNMENT_ERROR
endif

.Cfatfspkg_install
	ld	hl,fatfs_data_area
	ld	de,fatfs_data_area+1
	ld	bc,fatfs_data_end-(fatfs_data_area+1)
	ld	(hl),0
	ldir				; clear workspace
	scf				; success
	ret

.Cfatfspkg_bye
	xor	a			; any partitions open on phys unit 0?
	push	iy			; save IY, as will be corrupted
	call	drive_partitions_physical
	pop	iy
	and	a
	jr	nz,cantbye
	ld	a,1			; or on phys unit 1?
	push	iy			; save IY, as will be corrupted
	call	drive_partitions_physical
	pop	iy
	and	a
	jr	nz,cantbye
	ld	a,(unit_translate)
	and	a
	jr	z,nounit0		; skip release of 0 if not reserved
	ld	c,a
	ld	b,FATFSPKG_ID
	ld	a,fs_release
	exx
	ld	b,PKG_IDEDOS
	ld	hl,IDE_FS_UNIT		; release unit 0
	call	PACKAGE_CALL_PKG
	jr	nc,cantbye		; some problem with release
.nounit0
	ld	a,(unit_translate+1)
	and	a
	scf
	ret	z			; exit with success if 1 not reserved
	ld	c,a
	ld	b,FATFSPKG_ID
	ld	a,fs_release
	exx
	ld	b,PKG_IDEDOS
	ld	hl,IDE_FS_UNIT		; release unit 1
	call	PACKAGE_CALL_PKG
	ret	c			; exit with success
.cantbye
	ld	a,rc_resi_package_in_use
	and	a
	ret

.Cfatfspkg_info
	cp	info_version
	jr	z,fatfspkg_getversion
	ld	a,rc_resi_unknown_reason	; other reasons unknown
	and	a
	ret
.fatfspkg_getversion
	ld	bc,FATFSPKG_VERSION	; version number
	scf				; success!
	ret
	
.Cfatfspkg_exp
	cp	exp_fs_snapdata
	jp	z,file_snapdata
	cp	exp_fs_setdrive
	jr	z,fatfs_setdrive
	cp	exp_fs_setuser
	scf				; silently ignore exp_fs_setuser
	ret	z
	cp	exp_boot
	jp	z,fat_initialise	; initialise at boot time
	ld	a,rc_resi_unknown_reason
	and	a
	ret
.fatfs_setdrive
	ld	a,b			; get new default drive
	cp	'A'
	jr	c,baddefdrive
	cp	'P'+1
	jr	nc,baddefdrive
	ld	(fat_defdrive),a	; set it
	scf
	ret
.baddefdrive
	ld	a,rc_badparam
	and	a
	ret

.Cfatfspkg_hook
.Cfatfspkg_channels
.Cfatfspkg_nmi
	ld	a,rc_resi_package_not_found
	and	a
	ret

.Cfatfspkg_fs
	jp	(iy)			; execute the IDEDOS call and exit

; IDEDOS/+3DOS calls that don't need to be implemented come here.

.fat_notimplemented
	ld	a,rc_notimp
	and	a
	ret


; ***************************************************************************
; *  FAT_INITIALISE                                                         *
; ***************************************************************************
; Entry: -
; Exit: Fc=1 (success)

.fat_initialise
	call	Cfatfspkg_install	; just clears workspace
	ld	a,$ff
	exx
	ld	b,PKG_IDEDOS
	ld	hl,DOS_SET_DRIVE	; get default drive from IDEDOS
	call	PACKAGE_CALL_PKG
	ld	(fat_defdrive),a	; save it
	ld	hl,0
	add	hl,sp
	ld	a,h
	cp	$f0			; is stack >=$f000?
	ld	hl,$fe00		; if not, save space at $fe00
	jr	c,save512bytes
	ld	hl,$be00		; otherwise, save space at $be00
.save512bytes
	push	hl			; save address of data
	ld	de,buf_buffers
	ld	bc,512
	ldir				; save the data
	pop	hl			; restore the address
	push	hl
	ld	b,0
	ld	de,unit_translate
	ld	ix,drive_unit0
	call	drive_setupunit		; setup partition handle for phys unit 0
	ld	b,1
	inc	de
	ld	ix,drive_unit1
	call	drive_setupunit		; setup partition handle for phys unit 1
	pop	de
	ld	hl,buf_buffers
	ld	bc,512
	ldir				; restore data
	scf				; success!
					; TBD: Should also automatically map any FAT partitions found
	ret
	

; TBD: Improve buffer usage
;
; TBD: Implement path handling
;
